/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ntfy;

import com.ibm.hwmca.fw.ntfy.AbstractSink;
import com.ibm.hwmca.fw.ntfy.EmailTemplate;
import com.ibm.hwmca.fw.ntfy.FilterList;
import com.ibm.hwmca.fw.ntfy.NotificationEvent;
import com.ibm.hwmca.fw.ntfy.NotificationService;
import com.ibm.hwmca.fw.ntfy.NotifyConstants;
import com.ibm.hwmca.fw.ntfy.UserObject;
import com.ibm.hwmca.fw.ntfy.email.Emailer;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;

public class EmailSink
extends AbstractSink
implements Serializable,
NotifyConstants {
    static final long serialVersionUID = 7908454113261937090L;
    private static final String TRACE_MASKT = "XNTYEMST";
    private static final String TRACE_MASKF = "XNTYEMSF";
    private static final String TRACE_MASKD = "XNTYEMSD";
    public static final Pattern LONG_MSG_PATTERN = Pattern.compile("@M");
    public static final Pattern SHORT_MSG_PATTERN = Pattern.compile("@S");
    public static final Pattern USER_EMAIL_PATTERN = Pattern.compile("@E");
    public static final Pattern USER_PAGER_PATTERN = Pattern.compile("@P");
    public static final Pattern USER_NAME_PATTERN = Pattern.compile("@U");
    public static final Pattern DATE_PATTERN = Pattern.compile("@D");
    private EmailTemplate _template = null;
    private transient Emailer _mailer = null;

    EmailSink() {
    }

    public EmailSink(String name, String description, FilterList filters, Map users) {
        super(name, description, filters, users);
    }

    public boolean pass(EventObject event) {
        return super.pass(event) && this.getTemplate() != null;
    }

    private void logEvent(short eventID, String eventText, String[] subs) {
    }

    private boolean getEmailer() {
        if (this._mailer == null) {
            Map props = NotificationService.getManager().getGlobalProperties();
            String server = "";
            try {
                server = (String)props.get("smtpserver");
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, e);
                String[] subs = new String[]{this.getName()};
                return false;
            }
            if (server == null) {
                Trace.trace(TRACE_MASKF, "notifyEvent:  smtp server is null, returning");
                String[] subs = new String[]{this.getName()};
                return false;
            }
            int port = 0;
            try {
                port = (Integer)props.get("smtpport");
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "notifyEvent:  problem getting smpt port");
                Trace.trace(TRACE_MASKF, e);
                String[] subs = new String[]{this.getName()};
                return false;
            }
            try {
                this._mailer = new Emailer(server, port);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "notifyEvent:  problem creating Emailer");
                Trace.trace(TRACE_MASKF, e);
                String[] subs = new String[]{this.getName()};
                return false;
            }
        }
        return true;
    }

    public String getEmailAddress(UserObject user) {
        String emailAddr = "";
        Map emailConfig = (Map)((Object)user.getAttribute("email"));
        if (emailConfig != null) {
            emailAddr = (String)emailConfig.get("DataMapEmail");
            if (emailAddr == null) {
                Trace.trace(TRACE_MASKF, "getEmailAddress:  email address was null");
                emailAddr = "";
            } else {
                Trace.trace(TRACE_MASKF, "getEmailAddress:  is " + emailAddr);
            }
        } else {
            Trace.trace(TRACE_MASKF, "getEmailAddress:  email config was null");
        }
        return emailAddr;
    }

    public void perform(EventObject eventObj, Collection users) {
        Trace.trace(TRACE_MASKT, "-> perform(" + eventObj + ") -- PERFORMING A NOTIFICATION");
        EmailTemplate template = this.getTemplate();
        if (template == null) {
            Trace.trace(TRACE_MASKF, "perform:  email template is null or deleted");
            String[] subs = new String[]{this.getName()};
            return;
        }
        if (!this.getEmailer()) {
            Trace.trace(TRACE_MASKF, "perform:  failed to create emailer");
            return;
        }
        Iterator i = users.iterator();
        UserObject user = null;
        while (i.hasNext()) {
            user = (UserObject)i.next();
            if (!user.isEnabled()) continue;
            this.perform(eventObj, user, template);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void perform(EventObject eventObj, UserObject user, EmailTemplate template) {
        Trace.trace("XNTYEMST", "-> perform(" + eventObj + ") -- PERFORMING A NOTIFICATION");
        Trace.trace("XNTYEMSF", "perform:  user is " + user);
        userContext = UserContext.getCurrentUserContext();
        event = (NotificationEvent)eventObj;
        usersLastNotifyTime = user.getLastNotifyTime();
        if (usersLastNotifyTime == null) {
            Trace.trace("XNTYEMSF", "perform:  users first notification");
        } else {
            minMinutes = 0;
            try {
                minMinutes = (Integer)NotificationService.getManager().getGlobalProperties().get("windowminutes");
            }
            catch (Exception e) {
                Trace.trace("XNTYEMSF", "perform:  failed to get global minutes key, using 0");
                Trace.trace("XNTYEMSF", e);
            }
            compareTime = Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale());
            compareTime.add(12, minMinutes * -1);
            if (usersLastNotifyTime.after(compareTime)) {
                Trace.trace("XNTYEMSF", "perform:  not performing notification because of frequency limit");
                subs = new String[]{this.getName(), user.getName()};
                return;
            }
        }
        emailAddr = this.getEmailAddress(user);
        try {
            block17: {
                block16: {
                    substitutions = new HashMap<Pattern, String>();
                    substitutions.put(EmailSink.LONG_MSG_PATTERN, event.getEventDescription() + " (long)");
                    substitutions.put(EmailSink.SHORT_MSG_PATTERN, event.getEventDescription() + " (short)");
                    substitutions.put(EmailSink.USER_NAME_PATTERN, user.getName());
                    df = DateFormat.getDateTimeInstance(2, 2, userContext.getLocale());
                    df.setTimeZone(userContext.getTimeZone());
                    substitutions.put(EmailSink.DATE_PATTERN, df.format(event.getEventTime().getTime()));
                    substitutions.put(EmailSink.USER_EMAIL_PATTERN, emailAddr);
                    substitutions.put(EmailSink.USER_PAGER_PATTERN, emailAddr);
                    template.resolveWith(substitutions);
                    if (!template.to().equals("") && !template.from().equals("")) break block16;
                    Trace.trace("XNTYEMSF", "perform:  aborting notification because to or from field was empty");
                    subs = new String[]{this.getName(), user.getName()};
                    var12_18 = null;
                    if (this._mailer == null) return;
                    ** GOTO lbl84
                }
                if (!template.subject().equals("") || !template.message().equals("")) break block17;
                Trace.trace("XNTYEMSF", "perform:  aborting notification because both subject and message are blank");
                subs = new String[]{this.getName(), template.getName()};
                ** GOTO lbl91
            }
            this._mailer.send(template.to(), template.from(), template.subject(), template.message());
            user.setLastNotifyTime(Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale()));
            subs = new String[]{this.getName()};
            ** GOTO lbl100
        }
        catch (Exception e) {
            Trace.trace("XNTYEMSF", "perform:  problems resolving template or sending email");
            Trace.trace("XNTYEMSF", e);
            subs = new String[]{this.getName()};
            var12_21 = null;
            if (this._mailer == null) return;
            try {
                this._mailer.close();
                return;
            }
            catch (Exception e) {
                Trace.trace("XNTYEMSF", e);
                Trace.trace("XNTYEMSF", "perform:  failed to close emailer");
                return;
            }
        }
        {
            catch (Throwable var11_28) {
                var12_22 = null;
                if (this._mailer == null) throw var11_28;
                ** try [egrp 3[TRYBLOCK] [9 : 590->600)] { 
lbl78:
                // 1 sources

                this._mailer.close();
                throw var11_28;
lbl80:
                // 1 sources

                catch (Exception e) {
                    Trace.trace("XNTYEMSF", e);
                    Trace.trace("XNTYEMSF", "perform:  failed to close emailer");
                }
                throw var11_28;
            }
lbl84:
            // 1 sources

            ** try [egrp 3[TRYBLOCK] [9 : 590->600)] { 
lbl85:
            // 1 sources

            this._mailer.close();
            return;
lbl87:
            // 1 sources

            catch (Exception e) {
                Trace.trace("XNTYEMSF", e);
                Trace.trace("XNTYEMSF", "perform:  failed to close emailer");
            }
            return;
lbl91:
            // 1 sources

            var12_19 = null;
            if (this._mailer == null) return;
            ** try [egrp 3[TRYBLOCK] [9 : 590->600)] { 
lbl94:
            // 1 sources

            this._mailer.close();
            return;
lbl96:
            // 1 sources

            catch (Exception e) {
                Trace.trace("XNTYEMSF", e);
                Trace.trace("XNTYEMSF", "perform:  failed to close emailer");
            }
            return;
lbl100:
            // 1 sources

            var12_20 = null;
            if (this._mailer == null) return;
            try {}
            catch (Exception e) {}
            Trace.trace("XNTYEMSF", e);
            Trace.trace("XNTYEMSF", "perform:  failed to close emailer");
            return;
            this._mailer.close();
            return;
        }
    }

    public void setTemplate(EmailTemplate et) {
        this._template = et;
    }

    public EmailTemplate getTemplate() {
        if (this._template != null) {
            this._template = (EmailTemplate)this._template.getCurrent();
        }
        return this._template;
    }
}

